<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * SiteController
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class WatchlistController extends Controller
{
	public function init()
	{
		 
		if(Yii::app()->user->getId()=="")
		{  
			Yii::app()->user->setReturnUrl(Yii::app()->request->requestUri );
			$this->redirect(Yii::app()->createUrl("user/signin"));
		} 
	}
    public function actionIndex($slug=null,$back=null)
    {
	 
		$model = new Watchlist();
	  
		 
		
		$ad = PlaceAnAd::model()->AdFromSlug($slug);
		if(empty($ad))
		{
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		}
		$criteria = new CDbCriteria;
		$criteria->condition="user_id=:id and ad_id=:ad";
		$criteria->params[':id']=Yii::app()->user->getId(); 
		$criteria->params[':ad']= $ad->id; 
    	Watchlist::model()->deleteAll($criteria);
		$model->user_id =  Yii::app()->user->getId(); 
		$model->ad_id   =  $ad->id; 
		$model->category_id   =  $ad->category_id; 
		if($model->save())
		{
		 
			Yii::app()->user->setFlash('success',"The listing has been added to your watchlist.");
			$this->redirect(Yii::app()->request->baseUrl.base64_decode($back));
			 
			exit;
		}
		else
		{
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		}
	 
	 
	 
	 
    }
    
  
 

}
